using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class PeopleImagesBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            MicroFour.StrataFrame.Business.BusinessParentRelationship BusinessParentRelationship1 = new MicroFour.StrataFrame.Business.BusinessParentRelationship();
            //
            //PeopleImagesBO
            //
            this.DeleteUsingStoredProcedure = true;
            this.InsertUsingStoredProcedure = true;
            BusinessParentRelationship1.ForeignKeyField = new string[] { "pli_pl_pk" };
            BusinessParentRelationship1.ParentBusinessObjectType = "StrataFlix.Business.PeopleBO";
            BusinessParentRelationship1.ParentPrimaryKeyField = new string[] { "pl_pk" };
            this.ParentRelationship = BusinessParentRelationship1;
            this.RowVersionOrTimestampColumn = "pli_Version";
            this.UpdateConcurrencyType = MicroFour.StrataFrame.Data.ConcurrencyTypeOptions.OptimisticRowVersion;
            this.UpdateUsingStoredProcedure = true;

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[pli_pk],[pli_pl_pk],[pli_ImageData],[pli_CreatedAt],[pli_CreatedBy],[pli_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "pli_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "PeopleImages";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("pli_pk", typeof(System.Int32)),
new DataColumn("pli_pl_pk", typeof(System.Int32)),
new DataColumn("pli_ImageData", typeof(System.Byte[])),
new DataColumn("pli_CreatedAt", typeof(System.DateTime)),
new DataColumn("pli_CreatedBy", typeof(System.Int32)),
new DataColumn("pli_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(PeopleImagesBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(PeopleImagesBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pli_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["pli_pk"];
            }
            set
            {
                this.CurrentRow["pli_pk"] = value;
            }
        }

        /// <summary>
        /// People Foreign Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("People Foreign Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pli_pl_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["pli_pl_pk"];
            }
            set
            {
                this.CurrentRow["pli_pl_pk"] = value;
            }
        }

        /// <summary>
        /// Image data
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Image data"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Byte[] pli_ImageData
        {
            get
            {
                return (System.Byte[])this.CurrentRow["pli_ImageData"];
            }
            set
            {
                this.CurrentRow["pli_ImageData"] = value;
            }
        }

        /// <summary>
        /// Time stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime pli_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["pli_CreatedAt"];
            }
            set
            {
                this.CurrentRow["pli_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// Created By
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Created By"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pli_CreatedBy
        {
            get
            {
                return (System.Int32)this.CurrentRow["pli_CreatedBy"];
            }
            set
            {
                this.CurrentRow["pli_CreatedBy"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 pli_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["pli_Version"];
            }
            set
            {
                this.CurrentRow["pli_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum PeopleImagesBOFieldNames
        {
            pli_pk,
            pli_pl_pk,
            pli_ImageData,
            pli_CreatedAt,
            pli_CreatedBy,
            pli_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(PeopleImagesBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<PeopleImagesBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<PeopleImagesBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<PeopleImagesBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the PeopleImagesBO class.
        /// </summary>
        static PeopleImagesBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(11);
            _PropertyDescriptors.Add("pli_pk", new FieldDescriptor(PeopleImagesBOFieldNames.pli_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("pli_pl_pk", new FieldDescriptor(PeopleImagesBOFieldNames.pli_pl_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("pli_ImageData", new FieldDescriptor(PeopleImagesBOFieldNames.pli_ImageData, typeof(System.Byte[])));
            _PropertyDescriptors.Add("pli_CreatedAt", new FieldDescriptor(PeopleImagesBOFieldNames.pli_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("pli_CreatedBy", new FieldDescriptor(PeopleImagesBOFieldNames.pli_CreatedBy, typeof(System.Int32)));
            _PropertyDescriptors.Add("pli_Version", new FieldDescriptor(PeopleImagesBOFieldNames.pli_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(6);
            _AllFieldsList.Add("pli_pk");
            _AllFieldsList.Add("pli_pl_pk");
            _AllFieldsList.Add("pli_ImageData");
            _AllFieldsList.Add("pli_CreatedAt");
            _AllFieldsList.Add("pli_CreatedBy");
            _AllFieldsList.Add("pli_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(6);
            _FieldDbTypes.Add("pli_pk", DbType.Int32);
            _FieldDbTypes.Add("pli_pl_pk", DbType.Int32);
            _FieldDbTypes.Add("pli_ImageData", DbType.Binary);
            _FieldDbTypes.Add("pli_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("pli_CreatedBy", DbType.Int32);
            _FieldDbTypes.Add("pli_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(7);
            _FieldEnums.Add("pli_pk", PeopleImagesBOFieldNames.pli_pk);
            _FieldEnums.Add("pli_pl_pk", PeopleImagesBOFieldNames.pli_pl_pk);
            _FieldEnums.Add("pli_ImageData", PeopleImagesBOFieldNames.pli_ImageData);
            _FieldEnums.Add("pli_CreatedAt", PeopleImagesBOFieldNames.pli_CreatedAt);
            _FieldEnums.Add("pli_CreatedBy", PeopleImagesBOFieldNames.pli_CreatedBy);
            _FieldEnums.Add("pli_Version", PeopleImagesBOFieldNames.pli_Version);
            _FieldEnums.Add("CUSTOM_FIELD", PeopleImagesBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(6);
            _FieldLengths.Add("pli_pk", 4);
            _FieldLengths.Add("pli_pl_pk", 4);
            _FieldLengths.Add("pli_ImageData", -1);
            _FieldLengths.Add("pli_CreatedAt", 8);
            _FieldLengths.Add("pli_CreatedBy", 4);
            _FieldLengths.Add("pli_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(6);
            _FieldNativeDbTypes.Add("pli_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("pli_pl_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("pli_ImageData", (int)System.Data.SqlDbType.VarBinary);
            _FieldNativeDbTypes.Add("pli_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("pli_CreatedBy", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("pli_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(6);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the PeopleImagesBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<PeopleImagesBOFieldNames>
        {
            public FieldDescriptor(PeopleImagesBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(PeopleImagesBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case PeopleImagesBOFieldNames.pli_pk:
                        return ((PeopleImagesBO)component).pli_pk;
                    case PeopleImagesBOFieldNames.pli_pl_pk:
                        return ((PeopleImagesBO)component).pli_pl_pk;
                    case PeopleImagesBOFieldNames.pli_ImageData:
                        return ((PeopleImagesBO)component).pli_ImageData;
                    case PeopleImagesBOFieldNames.pli_CreatedAt:
                        return ((PeopleImagesBO)component).pli_CreatedAt;
                    case PeopleImagesBOFieldNames.pli_CreatedBy:
                        return ((PeopleImagesBO)component).pli_CreatedBy;
                    case PeopleImagesBOFieldNames.pli_Version:
                        return ((PeopleImagesBO)component).pli_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case PeopleImagesBOFieldNames.pli_pk:
                        ((PeopleImagesBO)component).pli_pk = (System.Int32)value;
                        break;
                    case PeopleImagesBOFieldNames.pli_pl_pk:
                        ((PeopleImagesBO)component).pli_pl_pk = (System.Int32)value;
                        break;
                    case PeopleImagesBOFieldNames.pli_ImageData:
                        ((PeopleImagesBO)component).pli_ImageData = (System.Byte[])value;
                        break;
                    case PeopleImagesBOFieldNames.pli_CreatedAt:
                        ((PeopleImagesBO)component).pli_CreatedAt = (System.DateTime)value;
                        break;
                    case PeopleImagesBOFieldNames.pli_CreatedBy:
                        ((PeopleImagesBO)component).pli_CreatedBy = (System.Int32)value;
                        break;
                    case PeopleImagesBOFieldNames.pli_Version:
                        ((PeopleImagesBO)component).pli_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
